/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.DefinitionModifierSlots;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.harvest.TagHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.module.IToolModule;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class ToolDefinitionDataBuilder {
    private final ImmutableList.Builder<PartRequirement> parts = ImmutableList.builder();
    private final StatsNBT.Builder bonuses = StatsNBT.builder();
    private final MultiplierNBT.Builder multipliers = MultiplierNBT.builder();
    private final DefinitionModifierSlots.Builder slots = DefinitionModifierSlots.builder();
    private final ImmutableList.Builder<ModifierEntry> traits = ImmutableList.builder();
    private final ImmutableSet.Builder<ToolAction> actions = ImmutableSet.builder();
    private final ModifierHookMap.Builder hookBuilder = new ModifierHookMap.Builder();
    @Nonnull
    private IHarvestLogic harvestLogic = IHarvestLogic.DEFAULT;
    @Nonnull
    private IAreaOfEffectIterator aoe = IAreaOfEffectIterator.DEFAULT;
    @Nonnull
    private IWeaponAttack attack = IWeaponAttack.DEFAULT;

    public ToolDefinitionDataBuilder part(IToolPart part, int weight) {
        this.parts.add((Object)PartRequirement.ofPart(part, weight));
        return this;
    }

    public ToolDefinitionDataBuilder part(MaterialStatsId stat, int weight) {
        this.parts.add((Object)PartRequirement.ofStat(stat, weight));
        return this;
    }

    public ToolDefinitionDataBuilder part(Supplier<? extends IToolPart> part, int weight) {
        return this.part(part.get(), weight);
    }

    public ToolDefinitionDataBuilder part(IToolPart part) {
        return this.part(part, 1);
    }

    public ToolDefinitionDataBuilder part(Supplier<? extends IToolPart> part) {
        return this.part(part, 1);
    }

    public <T> ToolDefinitionDataBuilder stat(IToolStat<T> stat, T value) {
        this.bonuses.set(stat, value);
        return this;
    }

    public ToolDefinitionDataBuilder stat(IToolStat<Float> stat, float value) {
        this.bonuses.set(stat, Float.valueOf(value));
        return this;
    }

    public ToolDefinitionDataBuilder multiplier(INumericToolStat<?> stat, float value) {
        this.multipliers.set(stat, value);
        return this;
    }

    public ToolDefinitionDataBuilder startingSlots(SlotType slotType, int value) {
        this.slots.setSlots(slotType, value);
        return this;
    }

    public ToolDefinitionDataBuilder smallToolStartingSlots() {
        this.startingSlots(SlotType.UPGRADE, 3);
        this.startingSlots(SlotType.ABILITY, 1);
        return this;
    }

    public ToolDefinitionDataBuilder largeToolStartingSlots() {
        this.startingSlots(SlotType.UPGRADE, 2);
        this.startingSlots(SlotType.ABILITY, 1);
        return this;
    }

    public ToolDefinitionDataBuilder trait(ModifierId modifier, int level) {
        this.traits.add((Object)new ModifierEntry(modifier, level));
        return this;
    }

    public ToolDefinitionDataBuilder trait(LazyModifier modifier, int level) {
        return this.trait(modifier.getId(), level);
    }

    public ToolDefinitionDataBuilder trait(ModifierId modifier) {
        return this.trait(modifier, 1);
    }

    public ToolDefinitionDataBuilder trait(LazyModifier modifier) {
        return this.trait(modifier, 1);
    }

    public ToolDefinitionDataBuilder action(ToolAction action) {
        this.actions.add((Object)action);
        return this;
    }

    public ToolDefinitionDataBuilder effective(class_6862<class_2248> tag) {
        return this.harvestLogic(new TagHarvestLogic(tag));
    }

    public <T extends IToolModule> ToolDefinitionDataBuilder module(ModifierHook<? super T> hook, T module) {
        this.hookBuilder.addHook(module, hook);
        return this;
    }

    public ToolDefinitionData build() {
        ModifierHookMap hooks;
        boolean isDefaultAOE;
        ImmutableList parts = this.parts.build();
        MultiplierNBT multipliers = this.multipliers.build();
        ImmutableList traits = this.traits.build();
        ImmutableSet actions = this.actions.build();
        ToolDefinitionData.Harvest harvest = null;
        boolean isDefaultHarvest = this.harvestLogic == IHarvestLogic.DEFAULT;
        boolean bl = isDefaultAOE = this.aoe == IAreaOfEffectIterator.DEFAULT;
        if (!isDefaultAOE || !isDefaultHarvest) {
            harvest = new ToolDefinitionData.Harvest(isDefaultHarvest ? null : this.harvestLogic, isDefaultAOE ? null : this.aoe);
        }
        if ((hooks = this.hookBuilder.build()).getAllModules().isEmpty()) {
            hooks = null;
        }
        return new ToolDefinitionData((List<PartRequirement>)(parts.isEmpty() ? null : parts), new ToolDefinitionData.Stats(this.bonuses.build(), multipliers == MultiplierNBT.EMPTY ? null : multipliers), this.slots.build(), (List<ModifierEntry>)(traits.isEmpty() ? null : traits), (Set<ToolAction>)(actions.isEmpty() ? null : actions), harvest, this.attack == IWeaponAttack.DEFAULT ? null : this.attack, hooks);
    }

    private ToolDefinitionDataBuilder() {
    }

    public static ToolDefinitionDataBuilder builder() {
        return new ToolDefinitionDataBuilder();
    }

    public ToolDefinitionDataBuilder harvestLogic(@Nonnull IHarvestLogic harvestLogic) {
        if (harvestLogic == null) {
            throw new NullPointerException("harvestLogic is marked non-null but is null");
        }
        this.harvestLogic = harvestLogic;
        return this;
    }

    public ToolDefinitionDataBuilder aoe(@Nonnull IAreaOfEffectIterator aoe) {
        if (aoe == null) {
            throw new NullPointerException("aoe is marked non-null but is null");
        }
        this.aoe = aoe;
        return this;
    }

    public ToolDefinitionDataBuilder attack(@Nonnull IWeaponAttack attack) {
        if (attack == null) {
            throw new NullPointerException("attack is marked non-null but is null");
        }
        this.attack = attack;
        return this;
    }
}

